/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.container.item;

import com.technicalitiesmc.lib.container.item.ItemContainer;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class SimpleItemContainer
implements ItemContainer.Serializable {
    private final NonNullList<ItemStack> items;
    @Nullable
    private final Runnable updateCallback;

    public SimpleItemContainer(int size, Runnable updateCallback) {
        this.items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.updateCallback = updateCallback;
    }

    public SimpleItemContainer(int size) {
        this(size, null);
    }

    public SimpleItemContainer(NonNullList<ItemStack> stacks) {
        this(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            this.items.set(i, (Object)((ItemStack)stacks.get(i)).m_41777_());
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public ItemStack get(int slot) {
        Objects.checkIndex(slot, this.size());
        return (ItemStack)this.items.get(slot);
    }

    @Override
    public void set(int slot, ItemStack stack) {
        Objects.checkIndex(slot, this.size());
        this.items.set(slot, (Object)stack);
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    public boolean isValid(int slot, ItemStack stack) {
        Objects.checkIndex(slot, this.size());
        return true;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    public ItemContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new Slice(from, to - from);
    }

    @Override
    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        ListTag slotList = new ListTag();
        for (ItemStack slot : this.items) {
            slotList.add((Object)slot.serializeNBT());
        }
        tag.m_128365_("slots", (Tag)slotList);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        ListTag slotList = tag.m_128437_("slots", 10);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)ItemStack.m_41712_((CompoundTag)slotList.m_128728_(i)));
        }
    }

    public static SimpleItemContainer from(NonNullList<ItemStack> items) {
        SimpleItemContainer inventory = new SimpleItemContainer(items.size());
        for (int i = 0; i < items.size(); ++i) {
            inventory.set(i, ((ItemStack)items.get(i)).m_41777_());
        }
        return inventory;
    }

    private class Slice
    implements ItemContainer {
        private final int from;
        private final int size;

        public Slice(int from, int size) {
            this.from = from;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public ItemStack get(int slot) {
            Objects.checkIndex(slot, this.size);
            return SimpleItemContainer.this.get(slot + this.from);
        }

        @Override
        public void set(int slot, ItemStack stack) {
            Objects.checkIndex(slot, this.size);
            SimpleItemContainer.this.set(slot + this.from, stack);
        }

        @Override
        public boolean isValid(int slot, ItemStack stack) {
            Objects.checkIndex(slot, this.size);
            return SimpleItemContainer.this.isValid(slot, stack);
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.size; ++i) {
                SimpleItemContainer.this.items.set(i + this.from, (Object)ItemStack.f_41583_);
            }
            if (SimpleItemContainer.this.updateCallback != null) {
                SimpleItemContainer.this.updateCallback.run();
            }
        }

        @Override
        public ItemContainer slice(int from, int to) {
            Objects.checkFromToIndex(from, to, this.size);
            return new Slice(this.from + from, to - from);
        }
    }
}

